<!-- start Simple Custom CSS and JS -->
<!-- Load Tippy.js -->
<script src="https://unpkg.com/@popperjs/core@2"></script>
<script src="https://unpkg.com/tippy.js@6"></script>

<!-- Tooltip Styling -->
<style>
  .tooltip-trigger.badge-tooltip {
    display: inline-block;
    cursor: help;
    vertical-align: middle;
  }

  .badge-icon {
    display: inline-block;
    background-color: #e0e7ff;
    color: #333;
    border-radius: 50%;
    font-size: 12px;
    font-weight: 500;
    width: 18px;
    height: 18px;
    line-height: 18px;
    text-align: center;
    position: relative;
  }

  .badge-icon .hidden-id {
    display: none;
  }

  
  .tippy-box[data-theme~='custom'] {
    position: relative;
    background: rgba(255, 255, 255, 0.2);
    border-radius: 16px;
    box-shadow: 0 4px 30px rgba(0, 0, 0, 0.1);
    backdrop-filter: blur(5px);
    -webkit-backdrop-filter: blur(5px);
    border: 1px solid rgba(255, 255, 255, 0.3);
    overflow: hidden;

    
    color: #111;
    font-size: 15px;
    font-weight: 500;
    font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
    padding: 12px 16px;
    line-height: 1.5;
    text-shadow: 0 1px 2px rgba(255, 255, 255, 0.6);
    transition: all 0.3s ease;
    z-index: 1;
  }

  .tippy-box[data-theme~='custom']::before {
    content: "";
    position: absolute;
    inset: 0;
    background: rgba(255, 255, 255, 0.4); 
    pointer-events: none;
    z-index: 0;
  }

  .tippy-box[data-theme~='custom'] .tippy-arrow {
    color: rgba(255, 255, 255, 0.2);
  }
</style>

<!-- Tooltip Logic -->
<script>
  document.addEventListener("DOMContentLoaded", function () {
    const mapContainer = document.getElementById('tooltip-map');
    if (!mapContainer) return;

    const tooltipMap = JSON.parse(mapContainer.getAttribute('data-tooltip-map'));

    const contentContainers = document.querySelectorAll(
      '.elementor-widget-container, .elementor-widget-text-editor, .elementor-widget-heading'
    );

    contentContainers.forEach(container => {
      let html = container.innerHTML;

      Object.entries(tooltipMap).forEach(([marker, content]) => {
        const safeMarker = marker.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&');
        const regex = new RegExp(safeMarker, 'g');
        html = html.replace(
          regex,
          `<span class="tooltip-trigger badge-tooltip" tabindex="0" aria-label="${content}" data-tippy-content="${content}">
             <span class="badge-icon">?<span class="hidden-id">${marker.replace(/\D/g, '')}</span></span>
           </span>`
        );
      });

      container.innerHTML = html;
    });

    const observer = new IntersectionObserver((entries) => {
      entries.forEach(entry => {
        if (entry.isIntersecting) {
          tippy(entry.target, {
            content: entry.target.getAttribute('data-tippy-content'),
            placement: 'top',
            allowHTML: true,
            theme: 'custom'
          });
          observer.unobserve(entry.target);
        }
      });
    });

    document.querySelectorAll('.tooltip-trigger').forEach(el => observer.observe(el));
  });
</script>
<!-- end Simple Custom CSS and JS -->
