<?php

  // Namespace
  namespace BMI\Plugin\Dashboard;

  // Use
  use BMI\Plugin\Backup_Migration_Plugin as BMP;

  // Exit on direct access
  if (!defined('ABSPATH')) exit;

  function siteURL() {
    $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
    $domainName = $_SERVER['HTTP_HOST'];

    return $protocol . $domainName;
  }

  // Tooltips
  $tooltip_files = __("Here are stored all plugin, theme, and WordPress installation files, as well as files from the Media Library and other folders and files located in your server's site directory. Note that WordPress keeps records of files such as those in the Media Library in the database, so you should also back up the database if you want WordPress to “see” recovered media files. The size defined here is the total size of raw files.", 'backup-backup');
  $tooltip_database = __("Databases in WordPress store the website's critical content and settings, including posts, pages, comments, users, configuration options, lists of (in)active plugins and themes, etc. Note that images and other media from posts and pages are not kept here.", 'backup-backup');
  $domain = site_url();
  $tooltip_exclude_file = __("Enter the paths to the files you want to exclude from your backup (one per line).", 'backup-backup');
  $tooltip_exclude_path = __("Enter the paths to the directories/folders you want to exclude from your backup (one per line).", 'backup-backup');
  $tooltip_premium_details = __("You can already exclude files based on filters (click on “Yes” below), however in the premium plugin you’ll also be able to browse through them.", 'backup-backup');

  $tooltip_files = str_replace('"', '“', $tooltip_files);
  $tooltip_premium_details = str_replace('"', '“', $tooltip_premium_details);

  if (defined('BMI_ALREADY_IN_PRO')) {
    $tooltip_smart_exclusion = str_replace('"', "'", BMI_ALREADY_IN_PRO);
  }

  $tooltip_premium_details .= '';
  if (!function_exists('bmi_cb_collapsible')) {
    function bmi_cb_collapsible($c) {
      echo ' class="bmi_will_collapse" data-if-checked="' . $c . '"';
    }
  }

  $pros = false;
  if (defined('BMI_BACKUP_PRO') && BMI_BACKUP_PRO == 1) {
    $pros = true;
  }

  if (!function_exists('bmi_pro_features')) {
    function bmi_pro_features($pros, $ready, $tooltip) {
      if ($pros) {
        echo 'function';
      } else {
        if ($ready) {
          $tooltipAttr = "data-ready";
        } else {
          if (defined('BMI_PREMIUM_TOOLTIP')) {
            $tooltip .= "<br><br>";
            $tooltip .= str_replace('"', "'", BMI_PREMIUM_TOOLTIP);
          }
          $tooltipAttr = "tooltip";

          
        }
        echo 'wrapper"' . $tooltipAttr . '="' . $tooltip ;
      }
    }
  }

?>

<!-- Files -->
<div class="mm mt lh30">
  <div class="mbl">
    <?php _e("Here you can define what exactly will be included in the backup. If your site is very large, it may make sense to back up only certain parts of it.", 'backup-backup'); ?>
  </div>

  <div class="">

    <label for="files-group-backup">
      <input id="files-group-backup"<?php bmi_cb_collapsible('file_group_cb'); ?> type="checkbox"<?php bmi_try_checked('BACKUP:FILES'); ?>>
      <span id="bmi-scan-total" class="relative">
        <b><?php _e("Files", 'backup-backup'); ?></b>
        <span class="value">(<div class="spinner-loader"></div>)</span>&nbsp;
        <span class="bmi-info-icon tooltip" tooltip="<?php echo $tooltip_files; ?>"></span>
      </span>
    </label>

  </div>

</div>

<div id="file_group_cb">
<div class="mm92 lh30 file-checkboxes-wrapper mbl npb">
  <div class="">
    <span class="medium"><?php _e("Select which files you want to have backed up.", 'backup-backup'); ?></span>
  </div>
  <div class="flex file-checkboxes basic-file-exlusion">

    <div class="backup-files-types">
      <label for="files-group-plugins" class="fit-content">
        <div class="cf nm">
          <div class="left nm" id="bmi-scan-plugins">
            <input type="checkbox" id="files-group-plugins"<?php bmi_try_checked('BACKUP:FILES::PLUGINS'); ?>>
            <span class="medium"><?php _e("Plugins", 'backup-backup'); ?></span> <span class="value">(<div class="spinner-loader"></div>)</span>
          </div>
        </div>
      </label>

      <div class="flex right mrr nm premium-<?php bmi_pro_features($pros, true, $tooltip_premium_details); ?>">
        <div class="nm">
          <a class="left f15 browse-details pointer" data-browsing-path="plugins">
            <?php _e("Details", 'backup-backup'); ?>
          </a>
          <span class="right premium premium-img"></span>
        </div>
      </div>
    </div>

    <div class="backup-files-types">
      <label for="files-group-uploads" class="fit-content">
        <div class="cf nm">
          <div class="left nm" id="bmi-scan-plugins">
            <input type="checkbox" id="files-group-uploads"<?php bmi_try_checked('BACKUP:FILES::UPLOADS'); ?>>
            <span id="bmi-scan-uploads">
              <span class="medium"><?php _e("Uploads", 'backup-backup'); ?></span> <span class="value">(<div class="spinner-loader"></div>)</span>
            </span>
          </div>
        </div>
      </label>
      <div class="flex right mrr nm premium-<?php bmi_pro_features($pros, true, $tooltip_premium_details); ?>">
        <div class="nm">
          <a class="left f15 browse-details pointer" data-browsing-path="uploads">
            <?php _e("Details", 'backup-backup'); ?>
          </a>
          <span class="right premium premium-img"></span>
        </div>
      </div>
    </div>

    <div class="backup-files-types">
      <label for="files-group-themes" class="fit-content">
        <div class="cf nm">
          <div class="left nm" id="bmi-scan-plugins">
            <input type="checkbox" id="files-group-themes"<?php bmi_try_checked('BACKUP:FILES::THEMES'); ?>>
            <span id="bmi-scan-themes">
              <span class="medium"><?php _e("Themes", 'backup-backup'); ?></span> <span class="value">(<div class="spinner-loader"></div>)</span>
            </span>
          </div>
        </div>
      </label>
      <div class="flex right mrr nm premium-<?php bmi_pro_features($pros, true, $tooltip_premium_details); ?>">
        <div class="nm">
          <a class="left f15 browse-details pointer" data-browsing-path="themes">
            <?php _e("Details", 'backup-backup'); ?>
          </a>
          <span class="right premium premium-img"></span>
        </div>
      </div>
    </div>

    <div class="backup-files-types">
      <label for="files-group-other-contents" class="fit-content">
        <div class="cf nm">
          <div class="left nm" id="bmi-scan-plugins">
            <input type="checkbox" id="files-group-other-contents"<?php bmi_try_checked('BACKUP:FILES::OTHERS'); ?>>
            <span id="bmi-scan-contents_others">
              <span class="medium"><?php _e("Everything else in wp-content", 'backup-backup'); ?></span> <span class="value">(<div class="spinner-loader"></div>)</span>
            </span>
          </div>
        </div>
      </label>
      <div class="flex right mrr nm premium-<?php bmi_pro_features($pros, true, $tooltip_premium_details); ?>">
        <div class="nm">
          <a class="left f15 browse-details pointer" data-browsing-path="other-contents">
            <?php _e("Details", 'backup-backup'); ?>
          </a>
          <span class="right premium premium-img"></span>
        </div>
      </div>
    </div>

    <div class="backup-files-types">
      <label for="files-group-wp-install" class="fit-content">
        <div class="cf nm">
          <div class="left nm" id="bmi-scan-plugins">
            <input type="checkbox" id="files-group-wp-install"<?php bmi_try_checked('BACKUP:FILES::WP'); ?>>
            <span id="bmi-scan-wordpress">
              <span class="medium"><?php _e("WordPress installation", 'backup-backup'); ?></span> <span class="value">(<div class="spinner-loader"></div>)</span>
            </span>
          </div>
        </div>
      </label>
      <div class="flex right mrr nm premium-<?php bmi_pro_features($pros, true, $tooltip_premium_details); ?>">
        <div class="nm">
          <a class="left f15 browse-details pointer" data-browsing-path="wp-install">
            <?php _e("Details", 'backup-backup'); ?>
          </a>
          <span class="right premium premium-img"></span>
        </div>
      </div>
    </div>

    <?php if(has_action('bmi_pro_files_exclude')): ?>
      <?php do_action('bmi_pro_files_exclude'); ?>
    <?php endif; ?>

  </div>
  <div class="mtl cf">
    <div class="left inline-radio">
      <?php _e("Want to exclude files based on filters?", 'backup-backup'); ?>
    </div>
    <div class="left d-flex mr60 ia-center">
      <label class="container-radio">
        <?php _e("No", 'backup-backup'); ?>
        <input type="radio" name="exclude_files_by_filters"<?php bmi_cb_collapsible('file_filters_exclusion'); ?> value="false"<?php bmi_try_checked('BACKUP:FILES::FILTER', true); ?>>
        <span class="checkmark-radio"></span>
      </label>
      <label class="container-radio ml25">
        <?php _e("Yes", 'backup-backup'); ?>
        <input id="files_by_filters" type="radio" name="exclude_files_by_filters"<?php bmi_cb_collapsible('file_filters_exclusion'); ?> value="true"<?php bmi_try_checked('BACKUP:FILES::FILTER'); ?>>
        <span class="checkmark-radio"></span>
      </label>
    </div>
  </div>
</div>

<!-- Files @ Filter (Excluder) -->
<div class="mm mtl mbl lh30 bg-second" id="file_filters_exclusion">
  <div class="rr">

    <div>
      <label for="ex_b_fs">
        <input type="checkbox" id="ex_b_fs"<?php bmi_cb_collapsible('file_filters_size'); ?><?php bmi_try_checked('BACKUP:FILES::FILTER:SIZE'); ?>>
        <span id="bmi-scan-plugins">
          <span class="medium"><?php _e("Exclude by", 'backup-backup'); ?> <b><?php _e("file size", 'backup-backup'); ?></b></span><span id="bmi__collon">:</span>
        </span>
      </label>
      <div class="rr mtll" id="file_filters_size">

        <?php _e("Do not back up files that are larger than", 'backup-backup'); ?>
        <input type="number" min="0" id="BFFSIN" class="mbfieldlimit" <?php bmi_try_value('BACKUP:FILES::FILTER:SIZE:IN'); ?>>
        MB

      </div>
    </div>
    <div class="mtl" side="left">
      <label for="ex_b_names">
        <input type="checkbox" id="ex_b_names"<?php bmi_cb_collapsible('file_filters_names'); ?><?php bmi_try_checked('BACKUP:FILES::FILTER:NAMES'); ?>>
        <span id="bmi-scan-plugins">
          <span class="medium"><?php _e("Exclude by", 'backup-backup'); ?> <b><?php _e("file / folder name", 'backup-backup'); ?></b> <?php _e("(case-sensitive)", 'backup-backup'); ?></span>
        </span>
      </label>
      <div class="rr" id="file_filters_names">

        <div id="bmi_exclusion_rules"></div>
        <div class="f16 hoverable mtll inline">
          <a href="#" id="add-exclusion-rule" class="nodec secondary hoverable">+ <?php _e("Add an exclusion rule", 'backup-backup'); ?></a>
        </div>

        <div class="mt">
          <?php _e('File names include the extension, e.g. if you select to exclude all files which end with “.psd” at the end then all files in psd format will be excluded.', 'backup-backup'); ?>
        </div>

        <div class="mtl mbll">
          <?php _e("The folder where backups are stored (i.e. the backups which this plugin creates) is always excluded, to prevent you from taking backups of your own backups.", 'backup-backup'); ?>
        </div>

      </div>
    </div>

    <div class="mtl" side="left">
      <label for="ex_b_fpaths">
        <input type="checkbox" id="ex_b_fpaths"<?php bmi_cb_collapsible('file_filters_fpaths'); ?><?php bmi_try_checked('BACKUP:FILES::FILTER:FPATHS'); ?>>
        <span id="bmi-scan-plugins" class="relative">
          <span class="medium"><?php _e("Exclude by", 'backup-backup'); ?> <b><?php _e("file path", 'backup-backup'); ?></b></span>&nbsp;
          <span class="bmi-info-icon tooltip" tooltip="<?php echo $tooltip_exclude_file; ?>"></span>
        </span>
      </label>
      <div class="rr mtll" id="file_filters_fpaths">

        <?php
          $ex0 = __('Examples:', 'backup-backup');
          $ex1 = BMP::fixSlashes(ABSPATH . 'wp-config.php');
          $ex2 = BMP::fixSlashes(ABSPATH . 'debug.log');
          $ex3 = BMP::fixSlashes(ABSPATH . 'readme.html');
        ?>

        <textarea id="dynamic-fpaths-names" class="fullwidth bmi-txtar" name="name" rows="6" cols="80" placeholder="<?php echo $ex0 . '&#10;' . $ex1 . '&#10;' . $ex2 . '&#10;' . $ex3 ?>">
        </textarea>

        <?php echo str_replace('%s', '<b>***ABSPATH***</b>', __('You can use there constant %s as your root path.', 'backup-backup')); ?>

      </div>
    </div>

    <div class="mtl" side="left">
      <label for="ex_b_dpaths">
        <input type="checkbox" id="ex_b_dpaths"<?php bmi_cb_collapsible('file_filters_dpaths'); ?><?php bmi_try_checked('BACKUP:FILES::FILTER:DPATHS'); ?>>
        <span id="bmi-scan-plugins" class="relative">
          <span class="medium"><?php _e("Exclude by", 'backup-backup'); ?> <b><?php _e("directory path", 'backup-backup'); ?></b></span>&nbsp;
          <span class="bmi-info-icon tooltip" tooltip="<?php echo $tooltip_exclude_path; ?>"></span>
        </span>
      </label>
      <div class="rr mtll" id="file_filters_dpaths">

        <?php
          $ex4 = BMP::fixSlashes(ABSPATH . 'wp-admin');
          $ex5 = BMP::fixSlashes(ABSPATH . 'wp-includes');
          $ex6 = BMP::fixSlashes(WP_CONTENT_DIR . '/uploads');
        ?>

        <textarea id="dynamic-dpaths-names" class="fullwidth bmi-txtar" name="name" rows="6" cols="80" placeholder="<?php echo $ex0 . '&#10;' . $ex4 . '&#10;' . $ex5 . '&#10;' . $ex6 ?>">
        </textarea>

        <?php echo str_replace('%s', '<b>***ABSPATH***</b>', __('You can use there constant %s as your root path.', 'backup-backup')); ?>

      </div>
    </div>

  </div>
</div>
</div>

<!-- Database -->
<div class="mm mtl lh30">
  <div class="">

    <label for="database-group-backup">
      <input id="database-group-backup"<?php bmi_cb_collapsible('database_group_cb'); ?> type="checkbox"<?php bmi_try_checked('BACKUP:DATABASE'); ?>>
      <span class="relative" id="bmi-scan-database">
        <b><?php _e("Databases", 'backup-backup'); ?>&nbsp;</b><span class="value">(<div class="spinner-loader"></div>)</span>
        <span class="bmi-info-icon tooltip" tooltip="<?php echo $tooltip_database; ?>"></span>
      </span>
    </label>

  </div>
</div>

<div id="database_group_cb">
  <div class="mm92 mbl lh30 file-checkboxes-wrapper">

    <div class="mbl">
      <span class="regular"><?php _e("All databases (on the domain", 'backup-backup'); ?> <a href="<?php echo $domain; ?>" target="_blank"><?php echo $domain; ?></a>) <?php _e("will be backed up unless you exclude them by defining exclusion rules.", 'backup-backup'); ?></span>
    </div>

    <?php if (has_action('bmi_pro_db_exclude_tables')): ?>
    <?php do_action('bmi_pro_db_exclude_tables'); ?>
    <?php else: ?>
      <div class="flex file-checkboxes">
        <div class="premium-wrapper" data-ready="Explore and select tables that you want to exclude from the backup">
          <label class="autowidth premium premium-img">
            <input type="checkbox" disabled>
            <span>
              <span class="regular text-muted"><?php _e("Exclude certain tables from backups", 'backup-backup'); ?></span>
            </span>
          </label>
        </div>
      </div>
    <?php endif; ?>

  </div>


</div>
  <div class="mm mtl lh30">

    <div class="cf">
      <div class="left inline-radio semibold">
        <?php _e('Want to apply "smart" exclusion rules?', 'backup-backup'); ?>
      </div>

      <div class="left d-flex mr60 ia-center">
        <label id="nnmysql" class="container-radio active">
          <?php _e("No", 'backup-backup'); ?>
          <input id="nnmysql" type="radio" name="smart_exclusion_db_first_bm" value="false" <?php bmi_try_checked('SMART:EXCLUSION:ENABLED', true); ?> <?php bmi_cb_collapsible('smart-exclusion-wrapper'); ?>>
          <span class="checkmark-radio"></span>
        </label>
        <span class="cf premium-<?php bmi_pro_features($pros, true, __("You will be able to exclude data from your database based on smart rules.", 'backup-backup')); ?>">
          <label class="left container-radio ml25 <?php echo ($pros) ? '' : 'not-allowed'; ?>">
            <?php _e("Yes", 'backup-backup'); ?>
            <input type="radio" name="smart_exclusion_db_first_bm" <?php echo ($pros) ? '' : 'disabled'; ?> id="smart-exclusion-enabled" <?php bmi_try_checked('SMART:EXCLUSION:ENABLED'); ?> <?php bmi_cb_collapsible('smart-exclusion-wrapper'); ?> value="true">
            <span class="checkmark-radio"></span>
          </label>
          <span class="left premium premium-img premium-nt mtf3"></span>
        </span>
      </div>
    </div>

  </div>

  <div class="mm lh30 mbll">
    <?php _e('With the "Files" and "Databases" options above you can already define what to include or exclude in your backup. However, you may want to exclude elements in your backups where you are not sure which file or table they reside in. For example, you may want to exclude all spam comments in your backups. This is what the "smart" exclusion rules are for. This is also a good way to clean your site of things you do not want.', 'backup-backup'); ?>
  </div>

  <div class="mm mtl mbl lh40 bg-second f20 overlayed" id="smart-exclusion-wrapper">

    <?php  if (!$pros):?>
      <?php include BMI_INCLUDES . '/dashboard/templates/premium-function-overlay.php'; ?>
    <?php endif; ?>


    <div class="cf">
      <label class="left half chhl">
        <input type="checkbox" name="smart-exclusion-cache" value="" id="smart-exclusion-cache" <?php bmi_try_checked('SMART:EXCLUSION:CACHE'); ?>>
        <span><?php _e("Exclude all", 'backup-backup'); ?> <b><?php _e("cache files", 'backup-backup'); ?></b></span>
      </label>
      <label class="left half chhl">
        <input type="checkbox" name="smart-exclusion-deactivated-plugins" value="" <?php bmi_try_checked('SMART:EXCLUSION:DPLUGINS'); ?> id="smart-exclusion-deactivated-plugins">
        <span><?php _e("Exclude all", 'backup-backup'); ?> <b><?php _e("deactivated plugins", 'backup-backup'); ?></b></span>
      </label>
      <label class="left half chhl">
        <input type="checkbox" name="smart-exclusion-debug-logs" value="" id="smart-exclusion-debug-logs" <?php bmi_try_checked('SMART:EXCLUSION:DLOGS'); ?>>
        <span><?php _e("Exclude all", 'backup-backup'); ?> <b><?php _e("debug logs", 'backup-backup'); ?></b></span>
      </label>
      <label class="left half chhl">
        <input type="checkbox" name="smart-exclusion-non-used-themes" value="" id="smart-exclusion-non-used-themes" <?php bmi_try_checked('SMART:EXCLUSION:NUTHEMES'); ?>>
        <span><?php _e("Exclude", 'backup-backup'); ?> <b><?php _e("all non-used themes", 'backup-backup'); ?></b></span>
      </label>
      <label class="left half chhl">
        <input type="checkbox" name="smart-exclusion-post-revisions" value="" id="smart-exclusion-post-revisions" <?php bmi_try_checked('SMART:EXCLUSION:PREVISIONS'); ?>>
        <span><?php _e("Exclude", 'backup-backup'); ?> <b><?php _e("post revisions", 'backup-backup'); ?></b></span>
      </label>
    </div>

  </div>

<div class="mm mt mblll bold">
  <?php _e("Summary / Sanity check", 'backup-backup'); ?>
</div>

<div class="mm mbl lh30 f20">
  <?php _e("With above exclusion rules you excluded", 'backup-backup'); ?> <b id="esta-exclude">0 B</b>/<b id="esta-exclude-total">0 B</b> <?php _e("of data, which means your backup will be about", 'backup-backup'); ?> <b id="esta-size-for">0 B</b> <?php _e("large, unzipped.", 'backup-backup'); ?>
  <br>
  <a class="get-file-database-sizes nodec secondary hoverable">– <?php _e('Save and re-calculate with current filters.', 'backup-backup'); ?></a>
</div>

<?php include BMI_INCLUDES . '/dashboard/chapter/save-button.php'; ?>
